# 915 MHz Bandpass Filter — FR4

A 3-pole edge-coupled microstrip bandpass filter for the 902–928 MHz ISM band, designed for FR4 substrate.

## Specifications

| Parameter | Value |
|-----------|-------|
| Center frequency | 915 MHz |
| Bandwidth | 26 MHz (902–928 MHz) |
| Passband ripple | 0.5 dB (Chebyshev) |
| System impedance | 50 Ω |
| Topology | 3-pole edge-coupled half-wave resonators |

## Substrate Parameters

| Parameter | Value |
|-----------|-------|
| Material | FR4 |
| Dielectric constant (εᵣ) | 4.4 |
| Loss tangent (tan δ) | 0.02 |
| Thickness | 1.6 mm |
| Copper weight | 1 oz (35 µm) |

## Physical Dimensions

| Element | Dimension |
|---------|-----------|
| Resonator width (W) | 3.0 mm |
| Resonator length (L) | 90 mm |
| Gap spacing (S₁₂, S₂₃) | 1.8 mm |
| Tap position | 6 mm from resonator end |
| Board size | 130 mm × 50 mm |

## Design Calculations

### 50Ω Microstrip Width

For FR4 (εᵣ = 4.4) with h = 1.6 mm:

```
W/h ≈ 1.9  →  W ≈ 3.0 mm
```

### Effective Dielectric Constant

```
εeff = (εᵣ + 1)/2 + (εᵣ - 1)/2 × 1/√(1 + 12h/W)
εeff ≈ 3.3
```

### Resonator Length (λ/2)

```
λ = c / (f × √εeff)
λ = 3×10⁸ / (915×10⁶ × √3.3) ≈ 180 mm
L = λ/2 ≈ 90 mm
```

### Coupling Gaps

For 0.5 dB Chebyshev ripple and 2.8% fractional bandwidth:

```
k₁₂ = k₂₃ ≈ 0.025  →  S ≈ 1.8 mm
```

## Files

- `915mhz-bpf-fr4.kicad_pro` — KiCad project file
- `915mhz-bpf-fr4.kicad_sch` — Schematic (SMA connectors)
- `915mhz-bpf-fr4.kicad_pcb` — PCB layout with microstrip geometry

## Fabrication Notes

1. **Order as 2-layer board** — Top copper has filter traces, bottom is solid ground
2. **Specify FR4 1.6mm** — Critical for impedance control
3. **1 oz copper** — Standard for this design
4. **HASL or ENIG finish** — Either works for RF at these frequencies
5. **No solder mask on resonators** — Optional, but exposes copper for tuning

## Assembly

- **J1, J2**: SMA edge-mount connectors (Amphenol 132289 or equivalent)
- **MH1–MH4**: M3 mounting hardware

## Tuning with NanoVNA-H

1. Connect NanoVNA-H port 1 to J1 (IN), port 2 to J2 (OUT)
2. Set sweep: 800 MHz to 1 GHz, 401 points
3. Calibrate with SOLT standards
4. Measure S21 — look for passband centered at 915 MHz
5. Measure S11 — return loss should be >15 dB in passband

### Common Issues

- **Center frequency low**: Resonators too long — trim ends with razor blade
- **Center frequency high**: Resonators too short — add copper tape at ends
- **Bandwidth too wide**: Gaps too small — cut copper between resonators
- **Bandwidth too narrow**: Gaps too large — add silver ink between resonators

## Expected Performance (FR4)

| Parameter | Typical Value |
|-----------|---------------|
| Insertion loss | 2.5–3.5 dB |
| Return loss | >15 dB |
| 3 dB bandwidth | 26 MHz |
| Out-of-band rejection | >20 dB at ±50 MHz |

Note: FR4 has significant dielectric loss at 900 MHz. For lower insertion loss (<1.5 dB), use Rogers RO4350B substrate with modified dimensions.

## License

Public domain — use freely for any purpose.

## Reference

Designed following the NanoVNA-H documentation tutorial: [Microstrip Bandpass Filter Design](/tutorials/microstrip-filter-design/)
